#include <RCSwitch.h>                 //Bibliothek für das Funkmodul 868MHz oder 433MHz
RCSwitch mySwitch = RCSwitch();       //Das Funkmodul wird ab jetzt mit "mySwitch" angesprochen
#include <Servo.h>                    //Bibliothek zur Servoansteuerung
Servo myservo;                        //Das Servo wird ab jetzt mit "myservo" angesprochen

                                      //Funkmodul-Empfänger an D2 anschließen
                                      //Servo an D9 anschließen

int code = 1711;                      //Hier den über das Funkmodul erwarteten Code eintragen
const int RelaisPin = 7;              //Relais an D7 anschließen (Low-Trigger; bei HIGH-Trigger-Relais müssen die Befehle HIGH und LOW vertauscht werden)
int Winkel1 = 50;                     //Hier Öffnewinkel des Servo eintragen
int Winkel2 = 150;                    //Hier Schließwinkel des Servo eintragen



void setup()
{
  Serial.begin(9600);
  mySwitch.enableReceive(0);          //Empfänger ist an Interrupt-Pin "0" - Das ist am UNO oder NANO der Pin2
  pinMode(RelaisPin, OUTPUT);
  myservo.attach(9);                  //verbindet das Servo mit Pin D9
  digitalWrite(RelaisPin, LOW);       //schaltet das Relais ein - Das angeschlossene Relais ist low trigger!
  myservo.write(Winkel1);             //öffnet den Riegel
  delay(8000);                        //8 Sekunden Zeit nach Einlegen der Batterie, den Deckel zu schließen
  myservo.write(Winkel2);             //Servo schließt
  delay(1500);
  digitalWrite(RelaisPin, HIGH);      //schaltet das Relais aus
  delay(1500);

}

void loop() 
{
   if (mySwitch.available())          //Wenn ein Code empfangen wird...
  { 
    int value = mySwitch.getReceivedValue(); //...werden die empfangenen Daten unter "value" gespeichert

    Serial.println(value);            //Befehl zur Ausgabe des Codes im seriellen Monitor
  
    if (value == code)                //Wenn der Code mit dem unter "code" eingestellen identisch ist
    { 
    digitalWrite(RelaisPin, LOW);     //Das Relais schaltet das Servo ein
    delay(1500);
    myservo.write(Winkel1);           //Servo öffnet 
    delay(10000);                     //Der Riegel ist 10sek. lang offen
    myservo.write(Winkel2);           //Servo schließt
    delay(500);
    digitalWrite(RelaisPin, HIGH);    //Das Relais schaltet das Servo aus
    mySwitch.resetAvailable();        //setzt den Empfänger zurück
    }

delay(5000);


  }
  
}

        
        
        



